@* Deleting a Vertex.
This is the general case for deleting a vertex of a simplex.
Deleting a vertex affects only simplices in |Sx|. All others remain
unchanged.\\
\begin{zitat}{\cite {BMS} p. 6}
Hence it is not necessary to reinsert points that are not in $R(x_i)$. We assume inductively
that we have $\Delta(\pi_{k-1} \setminus \{x_i\})$ and $\Delta(\pi \setminus \{x_i\}\cap
\Delta(\pi)$ and the set $B_{k-1}$ of facets of $CH(\pi_{k-1} \setminus x_i)$, that are
$x_i$-visible or contain $x_i$ in their affine hull and are new. If $x_i \notin DJ$, $B_i$
is the collection of facets opposite to $x_i$ in the simplices in $S_i(x_i)$.
Reinsertion of $x_k$ means to add a simplex $S(F,x_k)$ for every $x_k$-visible facet $F$
of $B_{k-1}$. The procedure for finding $x_k$-visible facets of $B_{k-1}$ is analogous to
\cite{CMS}.
\end{zitat}\\
We have a "hole" in the triangulation consisting of the simplices containing
|x|. How it is filled shows figure \ref{inner_point}. In this way we handle
all points. $B$ corresponds to |newfacets| and |vbfacets|. We actually do
not store the real base facet, but the facet of the neighbor that shares
the facet we want. This way we avoid using simplices from |Sx|, of which
we not always know if they are already deleted or not. Besides we need
the neighbors anyway for updating their neighborhood.
\label{del non-dj}
\begin{figure}[htb]
\begin{center}
\input{inner_point.latex}
\end{center}
\caption[Rebuilt Simplices]{\label{inner_point}Point 3 is deleted from
 the triangulation.\\ Resinserted points are 4 (previously inner point of
 some simplex) 5, 6, 7.}
\end{figure}
\begin{figure}[htb]
\begin{center}
\input{outer_point.latex}
\end{center}
\caption[Rebuilt unbounded Simplices]{\label{outer_point}
Point 4 is deleted.\\ Reinsertion of point 5 induces one new bounded and
two new unbounded simplices.}
\end{figure}

Unfortunately we could have deleted an outer point, which was limiting the
current triangulation. We handle this special case by inserting the
anti-origin $\overline{O}$ as the last point because it sees all
the remaing uncovered facets, but not storing it in any
simplex if it has no visible new base facets. ($\overline{O}$ does per 
definition not lie in any simplex.)
The strategy for this is shown in figure \ref{outer_point}.

Another special case are inner points inserted {\em before} |x|. These
must lie on the facet towards |x| (or even have the same coordinates as some vertex)
because if this would not be the case, they would have let to the
creation of a simplex of their own. So they will remain inner points, although they
now belong to a different simplex. They have to be reinserted for this
reason, as their simplex has |x| as a vertex and is to be deleted,
even if their |order_nr| is lower than |order_nr[x]|.

Two major informations are to manage. First, the set of facets without
a neighbor. Second the set of facets without a neighbor visible by the
current point. For both we use similiar constructions: a |list| of
pointers to simplices and a |list| of facets (described by
their order number) associated with each
simplex. So we can traverse the list of uncovered facet by traversing the
list of simplices containing uncovered facets and then for each such
simplex traversing the list of its uncovered facets. The set of
uncovered facets is described by |newfacets| and |visi_facet|, the set
of |x|-visible facets by |vbfacets| and |xvisi_facets|.

We reinsert the points in the same order as we we inserted them originally.
Therefore we sorted |Rx|. For each point we find the facets it sees for building
simplices out of them. A slightly different strategy applies for the |anti_origin|
for that. When we found any visible facets we build the simplices with the current
point as peak. Otherwise we try to insert the point in an already built simplex
as inner point. When it was a vertex but not the |anti_origin| we look for horizon
ridges resulting from this point. Then we go on to the next point.

When all points are inserted we handle the case of a newly built origin simplex.
Then we adjust the |simplex[]| pointers for all vertices of the new simplices.
Now we have done everything and finally delete |x| from the list of points.

@<delete non-dimjmp@>=
{
h_array<Simplex *,list<int> *> visi_facet(nil);
// stores facet of simplex that shares the facet (neighbor)
list<Simplex *> newfacets; // to be "provided" 
h_array<Simplex *,list<int> *> xvisi_facet(nil);
list<Simplex *> vbfacets; // visible by current point 
list<Simplex *> newsimplices; //filling the "hole" of Sx 
list_item p;  // the point we're reinserting
Simplex *sim;

@<initialize newfacets@>@;
Rx.append((list_item)anti_origin);  // $\overline{O}$ for unbounded simplices
while (!Rx.empty())
 {
  p=Rx.pop();
  if ((order_nr[p]>=order_nr[item_x]) ||  // only vertices after |x| are reinserted
      (p == anti_origin) ||               // or the anti-origin
      (position[p]!=nil))                        // or inner points
   {
    if ((position[p]==nil) || // vertices
     (order_nr[p]>=order_nr[item_x])) // inner points inserted after |x|
      if ( p != anti_origin)
	@<collect visible base facets@>@;
      else
	@<copy newfacets to visible facets@>;
    if (!vbfacets.empty())
      @<build simplices for p@>@;
    else
      if (p != anti_origin)
        @<insert point in a new simplex@>@;
    if ((position[p]==nil) && (p != anti_origin))
      @<add to newfacets@>@;   // see if there are horizon ridges
   }
 }
@<special treatment of newly built origin simplex@>@;
@<handle lost simplices for points@>@;
forall(sim,Sx) // only unbounded left
 {
  all_simplices.del_item(sim->this_item);
  delete sim;
 }
simplex[item_x] = nil;
position[item_x] =nil;
order_nr[item_x] = -1;
coordinates.del_item(item_x);
}

@ We initialize |newfacets| with the base facets of all simplices with |x|
as peak. Additionally we take some other facets when |x| is a dimension
jump and |new_dj| lies in a different halfspace than |x| (|is_dj==2|).
\begin{zitat}{\cite{BMS}, p. 6} 
Here $B_{i+1}$ is the collection of facets opposite to $x_i$ in the simplices
in $S_{i+1}(x_i)$.
\end{zitat} This simply means that we have to compare the insertion order
number of the peak vertex of each simplex  in |Sx|
with the order number of the |new_dj|.  If it is lower, the facet towards
|x| is taken. Because we made |x| ''peak'' of the |origin_simplex| we can
handle this as the general case.
\label{initialize newfacets}
Remember that we do not store these facet but the facet of the simplex
that shares it.

We use some auxiliary |list_item|s to walk through  the list,
because {\sc Leda} objects to modify the current item in an
iteration. So we use the item following the current one 
as iterator to satisfy {\sc Leda}. We have to keep this
thing in mind when we finish an iteration. Then we have to make
the next item the current. We can iterate |list|s only by
items, so we have to dereference them to get the information
in a list one by one.
The same thing also hold for almost
all iterations of |list|s in this chapter.

We look up the neighbor of the simplex in |Sx| we wish to
store in  |newfacets|. |newfacets| constist of pointers to
|list|s so we have to create one if we need to.
In |visi_facet| we store the index of the point describing our
facet. This index is relative to neighbor, because we want to store
the facet opposite to the one that we really mean. Next we can
delete this simplex because we don't need it anymore.
To ease testing we set the neighborhood pointer back to nil
for the deleted simplex.

@<initialize newfacets@>=
{
list_item s,n;
Simplex *sim,*neighbor;

  s=Sx.first_item();
  while(s!=nil)
  // initially all base facets of |x| are considered
   {
    n=Sx.next_item(s);
    sim=Sx[s];
    if ((sim->vertices[0]==item_x) || @| // all cases (|x|$\equiv peak(O)$)
	((is_dj==2) && (sim->vertices[0]!=anti_origin) &&  @| // not the |anti_origin|
	 (order_nr[sim->vertices[0]] <=
	  order_nr[origin_simplex->vertices[facet[origin_simplex]]])))
	  // see \cite{BMS} p. 6
     {
      neighbor=sim->neighbors[facet[sim]];
      if (visi_facet[neighbor] == nil) {
	visi_facet[neighbor]=new @+ list<int>;
	newfacets.append(neighbor);
      }
      visi_facet[neighbor]->append(sim->opposite_vertices[facet[sim]]);
      neighbor->neighbors[sim->opposite_vertices[facet[sim]]]=nil;
      // the simplex is not needed anymore
      all_simplices.del_item(sim->this_item);
      delete sim;
      Sx.del_item(s); 
     }
    s=n;
   }
}

@ In this section we scan through the |newfacets| to see if they are
visible by the point to be reinserted. If so they are inserted in
|vbfacets| and deleted from |newfacets|. Besides we take care of the
creation of lists when they are needed and destroy them when they are empty.

The outer |while|-loop scans through all simplices in
|newfacets|. The inner |while|-loop scans through all "uncovered"
facets by a simplex in |newfacets|. If it is visible by the
point indicated by |p| then we move it to |xvisi_facet[sim]|,
eventually creating a new list when needed.
Back in the outer loop we check if we still need the list of visible
facets for the current simplex.
\label{collect visi-sec}


@<collect visible base facets@>=
{ //Glob. Vars: |p|
list_item f,n,l,m;
Simplex *sim;
int i;

    f=newfacets.first_item();
    while(f!=nil) // forall simplices
     {
      n=newfacets.next_item(f);
      sim=newfacets[f];
      l=visi_facet[sim]->first_item();
      while(l!=nil) // forall facets
       {
        m=visi_facet[sim]->next_item(l);
        i=(*visi_facet[sim])[l];
	if (sees_facet(sim,i,coordinates[p]) < 0)
         {
          if (xvisi_facet[sim] == nil)
           {
            xvisi_facet[sim] = new @+ list<int>;
            vbfacets.append(sim);
           }
          xvisi_facet[sim]->append(i);
          visi_facet[sim]->del_item(l);
         }
        l=m;
       }
      if (visi_facet[sim]->empty())
       {
        delete visi_facet[sim];
        visi_facet[sim]=nil;
        newfacets.del_item(f);
       }
      f=n;
     }
}

@ This is the simpler case of the previous section when the |anti_origin| is
reinserted to create new unbounded simplices if we delete an outer point.
All newfacets are visible. Separatly copying them is not necessary by
using {\sc Leda}'s $list.conc()$-function. It concatenates the
second list after the first by changing some {\sc
Leda}-internal pointers with the result of |vbfacets|
consisting of the old |vbfacets| (empty) followed by the
contents of |newfacets|. |newfacets| is empty after this step.

Additionally we collect all bounded simplices left over in |Sx|.
The loop is almost the same as in section \ref{collect visi-sec},
except that we take every bounded facet in the |if|-clause. Still remember that
we have the opposite facet of the one from a simplex in |Sx|
in |vbfacets| and |xvisi_facet|.

@<copy newfacets...@>=
{
list_item s,n;
Simplex *sim,*neighbor;

vbfacets.conc(newfacets); // assume vbfacets should be empty
xvisi_facet=visi_facet;
s=Sx.first_item();
while(s!=nil) {
  n=Sx.next_item(s);
  sim=Sx[s];
  if (sim->vertices[0]!=anti_origin) { // bounded simplices only
    neighbor=sim->neighbors[facet[sim]];
    if (xvisi_facet[neighbor]==nil) {
      xvisi_facet[neighbor]=new @+ list<int>;
      vbfacets.append(neighbor);
    }
    xvisi_facet[neighbor]->append(sim->opposite_vertices[facet[sim]]);
    neighbor->neighbors[sim->opposite_vertices[facet[sim]]]=nil;
    all_simplices.del_item(sim->this_item);
    delete sim;
    Sx.del_item(s);
  }
  s=n;
}
}

@ For all visible base facets we build a new simplex with current point p
as peak. Here is the place where we need |vbfacets| and
|xvisi_facet|. The outer |while|-loop goes through all
simplices containing at least one  facet visible to |x|, the
inner |while|-loop walks through all facets belonging to a
simplex. 
The |pop()|-function of {\sc Leda} return the first element of
a list and removes it from the list (similiarly to a stack),
so |vbfacets| will be empty again after this step.

@<build simplices for p@>=
       { // Glob. Vars: |p|
	Simplex *sim;
	int f;

	while (!vbfacets.empty())
	 {
	  sim=vbfacets.pop();
	  while (!xvisi_facet[sim]->empty())
	   {
	    f=xvisi_facet[sim]->pop();
	    @<build simplex@>@; //and look for neighbors and new facets
	   }
	  delete xvisi_facet[sim];
	  xvisi_facet[sim]=nil;
	 }
       }

@ We found a visible facet and build a new simplex
with this facet as base and the current point as peak. The only
neighbor we know at this time is the neighbor sharing the base facet
of the new simplex. Still remember that |sim| and |f| denote
the opposite of the base facet of this simplex, so this
neighborhood information is filled in easily.

What are the points of the new simplex? The zeroth point is
already given by |p|. The remaining points are those of |sim|
(the simplex that shares the base face of the new simplex)
except the one opposite to the base facet of |new_sim|.
This point has the same index as the facet opposite to it,
namely |f|. So we know all points of the new simplex and fill
them in.
The other neighborhood information is filled in
later.  Now the |new_sim| is added to |all_simplices| and
|newsimplices|.

@<build simplex@>=
{// Glob. Vars: |p,sim,f|
int i,j;
Simplex *new_sim;

new_sim=new Simplex(dmax);
new_sim->vertices[0]=p;
new_sim->neighbors[0]=sim;
new_sim->opposite_vertices[0]=f;
sim->neighbors[new_sim->opposite_vertices[0]]=new_sim;
sim->opposite_vertices[new_sim->opposite_vertices[0]]=0;
for(i=0,j=1;i<=dcur;i++)
  if (i != new_sim->opposite_vertices[0])
    new_sim->vertices[j++]=sim->vertices[i];
@<put in neighborh...@>@;
new_sim->this_item=all_simplices.append(new_sim);
newsimplices.append(new_sim);
}

@ We have to complete the neighborhood of a newly built simplex.
That means we have to look for a neighbor that shares a facet with
the new simplex for every facet except the base facet. If we
find none then this facet will get its neighbor later when we
come here again for another simplex just been built.
We mark this state in an |array newf| to  add it to |newfacets|
later.

First we try to find a neighbor among the simplices in |Sx|.
There are two cases to distinguish. When we try to complete a
bounded simplex we use a different strategy than for an
unbounded simplex.
It is possible for the new simplex to have another facet from
this set that was not visible by its peak point, e.g the last
simplex built to fill a hole in the triangulation.
Next we test if a simplex recently built to reconstruct the
triangulation has a facet in common with the new simplex if no
neighbor was found in the previous try.

When a facet is left uncovered, it is "new" and added to |newfacets|.
Note that we start with facet 1 as the base facet is always covered by
the step in the previous section.

Now that we know all our neighbors we can update |newfacets|
for the next simplex that is to built.

@<put in neighborhood and newfacets@>=
{ //Glob. Vars: |new_sim|
int i;
array<bool> newf(0,dcur);
 // indicates whether |new_sim| already has a neighbor opposite to vertex |i|

newf[0]=false;
for (i=1;i<=dcur;i++)
 {
  newf[i]=true;
  if (new_sim->vertices[0]!=anti_origin)
    @<test edge facets@>@;
  else
    @<look for neighborhood of unbounded simplex@>@;
  if (newf[i]==true) // no edge facet coverd
    @<test newfacets@>@;
 }
@<collect new facets@>@;
}

@ Here we look for the neighbor's data in every "old"
simplex in |Sx| to copy them.
If the new and the old simplex have the same facet
looking towards |x|, we can copy the neighborhood data and the old
simplex is not needed anymore, so we delete it.
For testing we use the |facets_equal()|-function defined in
section \ref{facets equal}. |i| indicates the facet for which
we are searching a neighbor. When we found one, we copy its
relevant data in the |new_sim|'s structure and set |newf[i]|
to |false|.

@<test edge facets@>=
{//Glob. Vars: |i,new_sim,newf|
list_item s,n;
Simplex *sim;

  s=Sx.first_item();
  while(s!=nil)
  // first the egdes of the "hole"
   {
    n=Sx.next_item(s);
    sim=Sx[s];
    if (facets_equal(new_sim,i,sim,facet[sim]))  // see Section \ref{facets equal}
     {
      new_sim->neighbors[i] = sim->neighbors[facet[sim]];
      new_sim->opposite_vertices[i] = sim->opposite_vertices[facet[sim]];
      newf[i] = false;
      all_simplices.del_item(sim->this_item);
      delete sim;
      Sx.del_item(s);
     }
    s=n;
   }
}

@ 
We have to set up the neighborhood of a newly inserted unbounded
simplex. We look at every facet of every simplex remaining in |Sx| if
it has a facet (exept its base) in common with the |new_sim|,
and if this is true we can copy the neighborhood information.
Unfortunately we cannot delete |sim| from |Sx| after that because
|sim| may have more than one facet from which we have to derive the
neighborhood relations. (see figure \ref{unbounded_point}.)
The last thing to do is to set |newf[i]| to |false|.
\begin{figure}[htb]
\begin{center}
\input{unbounded_point.latex}
\end{center}
\caption[Neighborhood of unbounded Simplex]
{\label{unbounded_point} $x$ is deleted, causing the unbounded
simplices $D_1$ and $D_2$ to disappear. $N$ is the new
unbounded Simplex replacing $D_1$ and $D_2$, for which the
neighborhood is to be obtained.}
\end{figure}

@<look for neighborhood...@>=
{ // Glob. Vars |i,new_sim,newf|
int j;
Simplex *sim;

  forall(sim,Sx)
   {
    for (j=1;j<=dcur;j++)
      if (facets_equal(new_sim,i,sim,j)) // see Section \ref{facets equal}
       {
        new_sim->neighbors[i]=sim->neighbors[j];
        new_sim->opposite_vertices[i]=sim->opposite_vertices[j];
	newf[i]=false;
       }
   }
}

@ 
Now we look at every facet in |newfacets| and |visi_facet| for
a facet shared with the |i|-th facet of |new_sim|.
We use again the double |while|-loop with the auxiliary
|list_item|s as in prior sections to compare every facet in
these lists with the |i|-th facet of |new_sim|.
When we found a neighbor, we put its data in the |new_sim|'s
structure and set |newf[i]| to |false|.
Additionally we can delete this facet from |visi_facet|
because it now has a neighbor and is therefore no longer
a possible base facet for later built simplices.
We may delete |visi_facet[sim]| when it is empty after the
inner loop.

@<test newfacets@>=
{// Glob. Vars: |new_sim, i|
list_item s,n,l,m;
Simplex *sim;
int j;

    s=newfacets.first_item();
    while(s!=nil)
     {
      n=newfacets.next_item(s);
      sim=newfacets[s];
      l=visi_facet[sim]->first_item();
      while (l!=nil)
       {
	m=visi_facet[sim]->next_item(l);
        j=visi_facet[sim]->contents(l);
        if (facets_equal(new_sim,i,sim,j)) // see Section \ref{facets equal}
         {
          new_sim->neighbors[i] = sim;
          new_sim->opposite_vertices[i] = j;
          newf[i] = false;
          visi_facet[sim]->del_item(l);
         }
	l=m;
       }
      if (visi_facet[sim]->empty())
       {
        delete visi_facet[sim];
        visi_facet[sim]=nil;
        newfacets.del_item(s);
       }
      s=n;
     }
}

@ We have to run through |newf| to test whether a facet is new. If this is
the case we append
it to the list of |newfacets| and |visi_facet| (if needed creating one for the |new_sim|).
Otherwise we can now complete the neighborhood pointers from the neighbor
back to the simplex itself.
Setting the pointers back to |new_sim| each time may be
overkill, but setting the right pointer never is definitivly
worse then setting it twice.

@<collect new facets@>=
{ // Glob. Vars: |newf,new_sim|
int i;

for (i=1;i<=dcur;i++)
  if (newf[i]==true)
   {
    new_sim->neighbors[i]=nil;
    if (visi_facet[new_sim] == nil)
     {
      visi_facet[new_sim]=new @+ list<int>;
      newfacets.append(new_sim);
     }
    visi_facet[new_sim]->append(i);
   }
  else
   {
    new_sim->neighbors[i]->neighbors[new_sim->opposite_vertices[i]] = new_sim;
    new_sim->neighbors[i]->opposite_vertices[new_sim->opposite_vertices[i]] = i;
   }
}

@ Now we are in the situation that we did not find any visible facets
for a reinserted point. So we have to find a simplex already built
(list |newsimplices|) the point lies in and append it to its list of interior
points. We try this only for non-vertices, as we would sometimes
insert a point twice otherwise.

A special case are unbounded simplices. We enter this test only if we
know the current point is an interior point of some simplex. So when
it lies in an unbounded simplex, it must lie on the base facet. 
(We cannot compute a plane equation for the other facets of an
unbounded simplex.) The next thing is that we 
do not want an unbounded simplex to have interior points, so we
attach it to its neighbor that shares the base facet.
\label{insert point}

When we found no simplex containing this point it will be built
soon, so we try the whole procedure again at later time and append the point again to
|Rx|.

@<insert point in a new simplex@>=
{// Glob. Vars: |p|
bool in=false;
Simplex *sim;
int i;

    if (position[p] != nil) { // a vertex will always be a vertex
      newsimplices.init_iterator();
      newsimplices.move_iterator(forward);
      while((!in)&&(newsimplices.get_iterator()!=nil)) {
	in=true;
	sim=newsimplices[newsimplices.get_iterator()];
	if (sees_facet(sim,0,coordinates[p]) < 0)
	  in = false;
	if (sim->vertices[0] != anti_origin)
	// unbounded simplices only have one computable facet
	  for (i=1;(i<=dcur)&&(in==true);i++)
	    if (sees_facet(sim,i,coordinates[p]) < 0)
	    //see also Section \ref{visibility search}
	      in=false;
	newsimplices.move_iterator(forward);
       }
    if (in) {
      if (sim->vertices[0] == anti_origin)
        sim=sim->neighbors[0];
      position[p]=sim->points.append(p);
      simplex[p]=sim;
    }
    else
    // Try again later to fit in this interior point
      Rx.append(p);
    }
}

@
We found no base facet visible for this vertex and no
simplex containing it. So we look in |Sx| for all simplices with |p|
as peak and add them to |newfacets|. This procedure looks similiar to
the one in section \ref{initialize newfacets}.

@<add to newfacets@>=
{// Glob. Vars: |p|
list_item s,n;
Simplex *sim,*neighbor;

  s=Sx.first_item();
  while(s!=nil)
   {
    n=Sx.next_item(s);
    sim=Sx[s];
    if (sim->vertices[0]==p) // if |p| adds a horizon ridge
     {
      neighbor=sim->neighbors[facet[sim]];
      if (visi_facet[neighbor] == nil) {
	visi_facet[neighbor]=new @+ list<int>;
	newfacets.append(neighbor);
      }
      visi_facet[neighbor]->append(sim->opposite_vertices[facet[sim]]);
      neighbor->neighbors[sim->opposite_vertices[facet[sim]]]=nil;
      all_simplices.del_item(sim->this_item);
      delete sim;
      Sx.del_item(s);
     }
    s=n;
   }
}

@ This is the special case where we have a new |origin_simplex| that has
just been built. We cannot assign this value before as it is newly computed.
\label{special treatment}

@<special ...@>=
   {
    if (is_dj==1) {
      origin_simplex=newsimplices.head();
    }
   }

@
We have to correct the |simplex[]|-array for the vertices of
the newly built simplices. The interior points were handled during
their insertion (section \ref{insert point}).
We cannot do this earlier because sometimes the
simplex belonging to a vertex did not exist yet at its insertion time.
We do not want to attach any points or vertices to unbounded simplices.
We avoid this
inconvenience by assigning their vertices to their bounded neighbor (nr.
0). Since they are shared, this is correct.
We have to reset |position| in case we made a former interior point to a
vertex, to keep the data structure consistent.

@<handle lost...@>=
{
Simplex *sim,*sim2;
int i;

forall(sim,newsimplices) {
  if (sim->vertices[0] != anti_origin) // bounded simplex
    sim2 = sim;
  else // unbounded simplex
    sim2 = sim->neighbors[0]; // th bounded neighbor
  for(i=0;i<=dcur;i++) {
    simplex[sim2->vertices[i]]=sim2;
    position[sim2->vertices[i]]=nil;
  }
}
}

@
You may have noticed that this chapters handles the case of deleting a
vertex in a different way than described in \cite{CMS}. I decided to
implement a straight forward algorithm that does everything necessary
only when needed because the algorithm in \cite{CMS} is even more
complicated than this one. They use the following data structure:
\begin{zitat}{\cite{CMS}, p. 13}
\begin{description}
\item[(A)] a triangulation $T$ which consists of $T(x_1, \ldots , x_{i-1}, x_{i+1},
\ldots , x_{k-1})$ and the simplices in $T(\pi)\cap T(\pi\setminus i)$,
\item[(B)] the set $B = B_{k-1}$, its neighborhood graph, and for each facet $F \in
B$ the simplex in $T$ incident to $F$ and the equation of the hyperplane supporting
$F$,
\item[(C)] a dictionary for set set of ridges in $B$.
\end{description}
\end{zitat}

Additionally they use a variation of
segment walk to find the visible facets for a point in constant time.
I use a linear search here, so the algorithm implemented here runs
by a factor of the size of the list of new facets slower than it is
possible. For the sake of simplicity I renounced implementing this
segment walk. Therefore it would be necessary not to delete simplices
of |Sx| after getting the information about facets out of them but to
preserve them as they are needed for the segment walk. This would
probably increase the running time by a considerably amount.

