@* The Dimension Jump.
\label{dimjmp}
If the point being inserted is a dimension jump, we have to add it to
the set of vertices of every simplex of the extended triangulation 
$\overline{\Delta}(\pi_{i-1})$
and for every simplex $F$ of $\Delta(\pi_{i-1})$, we have to add
a new simplex $S(F \cup \{\overline{O}\})$ 
whose base facet is the corresponding
simplex of the old triangulation and whose peak is the
|anti_origin|.
To do so, we visit all simplices of the old triangulation starting
at the origin simplex and visiting all neighbors of a visited simplex
recursively.
This is done by the function |dimension_jump()|.
@<Further mem...@>+=
void dimension_jump(Simplex *S, list_item x);

@
Before we do a dimension jump, we compute the new center of the
extended origin simplex and set the |simplex[]| pointer of the new point
approbriate.

@<Dimension jump@>=
    dcur++;
    quasi_center += x;
    simplex[item_x]=origin_simplex;
    dimension_jump(origin_simplex, item_x);
    clear_visited_marks(origin_simplex);





@ 
In this section we describe the function |dimension_jump()|. Before we
do this, we give an example of a dimension jump in the two
dimensional case.
\label{func_dimjmp}
The following figure shows a typical constellation of vertices before
a dimension jump.
\begin{figure}[htb]
\begin{center}
\input{dim1.latex}
\end{center}
\caption{We are in dimension 1}
\end{figure}

The origin simplex is conv$(x_1,x_2)$. The point $x_3$ is {\sl not}
a dimension jump, because it lies on the line through $x_1$ and $x_2$.
At this point we have four simplices: two unbounded ones to the left
and to the right with the anti-origin as their peak, the origin
simplex and the simplex conv$(x_2,x_3)$ with peak $x_3$ and the base
facet $x_2$.

Now we do a dimension jump by inserting a point $x_4$ not colinear
with the other ones.

\begin{figure}[htb]
\begin{center}
\input{dj.latex}
\end{center}
\caption{A dimension jump}
\end{figure}
We have jumped to dimension 2. Now we have six simplices. For the
simplices conv$(x_1,x_2)$ and conv$(x_2,x_3)$ we have added two unbounded simplices below
having $\overline{O}$ as peak. The origin simplex is now
conv$(x_1,x_2,x_4)$. The simplex conv$(x_2,x_3,x_4)$ has base facet
conv$(x_2,x_3)$ and peak $x_4$. It is the neighbor of the simplex with
the vertices $x_2,x_3$ and $\overline{O}$ opposite to the vertex $\overline{O}$.

We can divide the simplices of $\overline{\Delta}(\pi_i)$ into three
classes:
\begin{itemize}
\item
{\em Bounded extended simplices}: they result from bounded simplices of
\linebreak
$\overline{\Delta}(\pi_{i-1})$ by adding $x$ to the set of vertices.
\item
{\em Unbounded extended simplices}:
they result from unbounded simplices of\linebreak$\overline{\Delta}(\pi_{i-1})$
by adding $x$ to the set of vertices.
\item
{\em New simplices}:
they result from bounded simplices of $\overline{\Delta}(\pi_{i-1})$
by adding $\overline{O}$ to the set of vertices.
\end{itemize}

In this and the subsequent sections we will use the following notation.
For a simplex $F$ of $\overline{\Delta}(\pi_{i-1})$ let
$v_0, \ldots, v_{\hbox{\scriptsize|dcur-1|}}$ be its vertices
($v_0$ is the peak).
Let $S = S(F \cup \{x\})$ denote the simplex resulting from
extending $F$.
If $F$ is bounded, let $|S_new| = S(F \cup \{\overline{O}\})$ be the
new simplex constructed for $F$.
The simplices of $\overline{\Delta}(\pi_i)$ look as follows:
\begin{itemize}
\item
A (bounded or unbounded) extended simplex $S$ has the vertices
$v_0,\ldots, \allowbreak v_{\hbox{\scriptsize dcur-1}},\allowbreak x$.
Since the peak of a simplex is defined to be the vertex inserted last
that was not a dimension jump, the peak
of $S$ is the same as the peak of $F$.
Thus we append $x$ to the list of vertices, i.e., we write the
appropriate entries at position |dcur|
into the arrays |vertices|, |neighbors| and |opposite_vertices|.
\item
A new simplex |S_new| has the vertices
$\overline{O}, v_0, \ldots, v_{\hbox{\scriptsize|dcur-1|}}$, where
$\overline{O}$ is the peak.
\end{itemize}

\noindent
In the following description
we will continue to make the distinction between a simplex $F$ of
$\overline{\Delta}(\pi_{i-1})$ and the extended simplex $S$ resulting
from it.
In the implementation, both correspond to the parameter $S$ of
|dimension_jump()|.
So every occurrence of $F$ in the following corresponds to $S$ in
the program.

|dimension_jump()| works as follows.
Starting at the origin simplex it visits all simplices
of $\overline{\Delta}(\pi_{i-1})$ using depth-first-search.
When a simplex $F$ is visited it is declared visited, $x$ is
added to its set of vertices (this turns $F$ into
$S = S(F \cup \{x\})$), and if the simplex is bounded then a new
unbounded simplex $|S_new| = S(F \cup \{\overline{O}\})$ is created.
Then all neighbors of $F$ in $\overline{\Delta}(\pi_{i-1})$ are
visited recursively.
(Note that only the neighbors |F->neighbors[0]|, \dots,
|F->neighbors[dcur-1]| are inspected).
Once all neighbors are visited we update the neighbor relation.
There we distinguish cases according to whether the simplex is bounded
or not.

@<Member f...@>+=
void Triangulation::dimension_jump(Simplex *S, list_item x)
{
  Simplex *S_new;

  S->visited = true;
  S->vertices[dcur] = x;
  if (S->vertices[0] != anti_origin) {
    // $S$ is bounded iff peak $\ne \overline{O}$
    @<Add a new unbounded simplex@>@;
  }
  /* The neighbor opposite to $x$ might not yet exist.
     We call |dimension_jump()| for all unvisited neighbors
     of $S$. */
  for (int k = 0; k <= dcur-1; k++) { // for all neighbors of $F$
    if (! S->neighbors[k]->visited) 
      dimension_jump(S->neighbors[k], x);
  }
  if (S->vertices[0] == anti_origin) {
    @<Complete neighborhood information if $F$ is unbounded@>@;
  }
  else {
    @<Complete neighborhood information if $F$ is bounded@>@;
  }
}


@
For every bounded simplex $F$ of $\overline{\Delta}(\pi_{i-1})$
we add a new simplex $|S_new| = S(F \cup \{\overline{O}\})$
with peak $\overline{O}$.
It is the neighbor of the bounded extended simplex
$S = S(F \cup \{x\})$ opposite to $x$, and $\overline{O}$ is
the vertex opposite to $x$.
For all vertices $v$ of $S$ different from $x$ the neighbor of $S$
opposite to $v$ is the simplex $S(F' \cup \{x\})$ where $F'$
is the neighbor of $F$ opposite to~$v$.
Thus no action is required in the algorithm.
%The new simplex $S'$ is the neighbor of the bounded extended
%simplex $S$ opposite to $x$.
%The vertex opposite to $x$ will be the peak of $S'$.
%For a vertex $v \ne x$ of $S$, the neighbor
%opposite to $v$ is the Simplex $\tilde S$ obtained by extending
%the neighbor $\tilde F$ of $F$ opposite to $v$.
%The vertex opposite to $v$ remains the same as in $F$.
%%Since the neighbors of $S$ opposite to $v \ne x$ are the simplices 
%%resulting from the corresponding neighbors of $F$
%%%and since $x$ will be inserted before
%%%$v_{\hbox{\scriptsize|dcur-1|}}$ in the array of vertices,
%%we can insert a pointer to the new simplex
%%after the last element of the array of the pointers to the
%%neighbors of $F$.
%By this, the neighborhood information of the bounded extended $S$ is
%already complete.
%The vertices of $S'$ are the vertices of $F$ plus $\overline{O}$ as
%the peak.
%Since |dimension_jump()| must only be called for simplices of
%$\overline{\Delta}(\pi_{i-1})$, we set the visited mark of the
%new simplex to |true|.
\label{Add a new unbounded simplex}

@<Add a new unbounded simplex@>=
S_new = S->neighbors[dcur] = new Simplex(dmax);
S_new->this_item=all_simplices.append(S_new);
S->opposite_vertices[dcur] = 0;
S_new->vertices[0] = anti_origin;
for (int k = 1; k <= dcur; k++)
  S_new->vertices[k] = S->vertices[k-1];


@
We discuss how to compute the neighbors of unbounded
extended simplices.
The neighbor of an unbounded extended simplex
$S = S(F \cup \{x\})$ opposite to $x$ is
the simplex $T$ with $\Vert(F) \subset \Vert(T)$
and $x \notin \Vert(T)$.
Consider the neighbor $F' \in \overline{\Delta}(\pi_{i-1})$
of $F$ opposite to $\overline{O}$.
$F'$ is bounded.
Hence we constructed a simplex $|S_new|'$ with
$\Vert(|S_new|') = \Vert(F') \cup \{\overline{O}\}$.
Since $\Vert(F) \setminus \{\overline{O}\} \subset \Vert(F')$
we have $\Vert(F) \subset \Vert(|S_new|')$.
Furthermore $x \notin \Vert(|S_new|')$.
Thus $T = |S_new|'$ is the neighbor of $S$ opposite to $x$.
We reach $T$ from $F$ (or $S$, respectively) by first going to
the $0$-th neighbor (that is $F'$ or $S'$, respectively) and then
going to the |dcur|-th neighbor of $S'$ which is $|S_new|' =
S(F' \cup \{x\}) = T$.
The vertex opposite to $x$ with respect to $S$ is the vertex~$w$
opposite to $\overline{O}$ with respect to $F$.
Note that if $w$ is the $i$-th vertex of $F'$ then it is the
$(i+1)$-st vertex of $|S_new|'$ since we have inserted the
anti-origin in |vertices[0]|.
%To update the neighborhood information of an unbounded $S$,
%we only have to write a pointer to $\tilde S$ according to
%(\ref{unboundedextended}) into the last (i.e., |dcur|-th) element
%of the |neighbors| array of $S$ and analogously for the
%|opposite_vertices| array.
%Note that $\tilde F$ is opposite to the peak of $F$, i.e.,
%a pointer to $\tilde F$ stands in |S->neighbors[0]|.

As in the previous section (bounded extended simplex), the neighborhood
information for vertices $v \ne x$ of $S$ is the same as for $F$
and hence there is nothing to do for them.

@<Complete neighborhood information if $F$ is unbounded@>=
S->neighbors[dcur] = S->neighbors[0]->neighbors[dcur];
S->opposite_vertices[dcur] = S->opposite_vertices[0] + 1;
@q// note that we have `shifted' the vertices of |S->neighbors[dcur]|@>
@q// one step to the right by inserting the anti-origin in |vertices[0]|@>


@
Let $F$ be a bounded simplex of $\overline{\Delta}(\pi_{i-1})$.
It gives rise to the extended simplex $S = S(F \cup \{x\})$ and the
new simplex $|S_new| = S(F \cup \{\overline{O}\})$.
The neighbors of $S$ were already computed in
Section~\ref{Add a new unbounded simplex}.
We still need to determine the neighbors of |S_new|.
In order to create the neighborhood information for a new
simplex |S_new|, we step through the
neighbors of $F$.
%(cf.\ (\ref{4}) and (\ref{5}))

To find the neighbor of |S_new| opposite to
$v \ne \overline{O}$ consider the neighbor
$F' \in \overline{\Delta}(\pi_{i-1})$ of $F$ opposite to $v$.
If $F'$ is unbounded, the neighbor of |S_new| opposite to $v$
is $S'$ and the vertex opposite to $v$ is $x$.
If $F'$ is bounded, the neighbor of |S_new| opposite to $v$
is the simplex $|S_new|'$ constructed for $F'$ and the
vertex opposite to $v$ remains the same as in $F$.
Note that a pointer to $|S_new|'$ has been added to the
|neighbors| array of $F'$ at position |dcur|
during a recursive or a previous call of |dimension_jump()|.

The neighbor of a new simplex $|S_new|$ opposite to $\overline{O}$ is
$S$.  The vertex opposite to $\overline{O}$ is $x$.
Recall %that |S->neighbors[dcur]| contains the pointer to $S'$ and
that the $k$-th vertex of $S$ is the $k+1$-st vertex of $S'$.
@<Complete neighborhood information if $F$ is bounded@>=
for (int k = 0; k < dcur; k++) {
  if (S->neighbors[k]->vertices[0] == anti_origin) {
     // if $F'$ is unbounded
    S_new->neighbors[k+1] = S->neighbors[k];
	// the neighbor of |S_new| opposite to $v$ is $S'$
    S_new->opposite_vertices[k+1] = dcur;
	// |x| stands in position |dcur|
  }
  else {
	// $F'$ is bounded
    S_new->neighbors[k+1] = S->neighbors[k]->neighbors[dcur];
	// neighbor of |S_new| opposite to $v$ is $|S_new|'$
    S_new->opposite_vertices[k+1] = S->opposite_vertices[k] + 1;
	// \dots\ vertex opposite to $v$ remains the same \dots
	// again remember the `shifting' of the vertices one step to the right
  }
}
/* the simplex opposite to $\overline{O}$ with respect to |S_new|
is $S$, and the vertex is $x$ */
S_new->neighbors[0] = S;
S_new->opposite_vertices[0] = dcur;



