/*11:*/
#line 25 "basics.w"

/*92:*/
#line 16 "main.w"


#include "chull.h"
#include <time.h> 

void tell_usage(string prg_name)

{
cout<<"Usage: "<<prg_name<<" [ m | k | f filename | p | n | s | V | M | S]*"<<endl;

exit(1);
}

/*:92*//*93:*/
#line 31 "main.w"


enum input_method{MOUSE,KEYS,INPUTFILE};

main(int argc,char**argv)
{
/*94:*/
#line 42 "main.w"

string_istream args(argc,argv);

string prg_name;
args>>prg_name;
string option;
string data_file= "/dev/null";


int dimension;
int number_of_points;

input_method read_from= MOUSE;
search_method m= SEGMENT_WALK;
bool draw_all= true;
bool suppress= false;
bool print_simplices= false;


while(true){
args>>option;
if(args.eof())break;
if(option.length()!=1)

tell_usage(prg_name);
switch(option[0]){
case'm':
read_from= MOUSE;
break;
case'k':
read_from= KEYS;
break;
case'f':


args>>data_file;
if(args.eof())

tell_usage(prg_name);
read_from= INPUTFILE;
break;
case'p':
print_simplices= true;
break;
case'n':
draw_all= false;
break;
case's':
suppress= true;
break;
case'V':
m= VISIBILITY;
break;
case'M':
m= MODIFIED_VISIBILITY;
break;
case'S':
m= SEGMENT_WALK;
break;
default:
tell_usage(prg_name);
break;
}
}

/*:94*/
#line 37 "main.w"

/*95:*/
#line 108 "main.w"



file_istream file_in(data_file);
if(!file_in){
cout<<"unable to open file "<<data_file<<endl;
exit(2);
}

switch(read_from){
case MOUSE:
{/*96:*/
#line 149 "main.w"

window W;
W.clear();
Triangulation T(2,m);
array<integer>L(0,2);
double a,b;
file_ostream protocol("chull.pts");
int mouse= 0;
L[0]= 100;
time_t now= time(nil);
protocol<<"Chull protocol from "<<ctime(&now)<<endl;
do{
mouse= W.read_mouse(a,b);

L[1]= a*100;
L[2]= b*100;
d_rat_point x(L,homogeneous);
if(mouse==1){
protocol<<"insert "<<x<<endl;
T.insert(x);
}
if(mouse==2){
x= T.find_closest_point(x);
protocol<<"delete "<<x<<endl;
T.del(x);
}
W.clear();
T.show(W);
if(print_simplices)T.print_all();
}
while(mouse!=3);
cout<<endl<<"Searched Simplices: "<<T.searched_simplices<<endl;
cout<<"Simplices created: "<<T.created_simplices()<<endl;



/*:96*/
#line 119 "main.w"

}
exit(0);
break;
case KEYS:
cout<<"Dimension of coordinate vectors: ";
cin>>dimension;
break;
case INPUTFILE:
file_in>>dimension;
file_in>>number_of_points;
break;
}
/*97:*/
#line 198 "main.w"


Triangulation T(dimension,m);
d_rat_point x(dimension);
int mouse;
array<integer>L(0,2);
L[0]= 100;
if(dimension==2&&!suppress){
window W;
W.clear();
do{
if(read_from==KEYS)
cin>>x;
else
file_in>>x;
if(!(file_in.eof()||cin.eof()))
T.insert(x);
if(!suppress&&draw_all){
W.clear();
T.show(W);
}
if(print_simplices)T.print_all();
}while(!(file_in.eof()||cin.eof()));
W.clear();
T.show(W);
cout<<"Press the right button in the drawing window to terminate,\n"
<<"or middle button to delete a random point.\n";
cout.flush();
while((mouse= W.read_mouse())!=3){
if(mouse==2){
L[1]= 50;
L[2]= 50;
d_rat_point x(L,homogeneous);
x= T.find_closest_point(x);
T.del(x);
W.clear();
T.show(W);
}
}
}
else{

do{
if(read_from==KEYS)
cin>>x;
else
file_in>>x;
if(!(file_in.eof()||cin.eof()))
T.insert(x);
if(print_simplices)T.print_all();
}while(!(file_in.eof()||cin.eof()));
list<d_rat_point>points= T.points();
points.permute();
cout<<"\n insert finished, now deleting points in random order\n\n";
cout.flush();
forall(x,points)
T.del(x);

}

cout<<endl<<"Searched Simplices: "<<T.searched_simplices<<endl;
cout<<"Simplices created: "<<T.created_simplices()<<endl;
cout.flush();


#line 1 "finish.w"
/*:97*/
#line 132 "main.w"



/*:95*/
#line 38 "main.w"
;
}

/*:93*/
#line 26 "basics.w"



/*:11*/
