
/*

With argument n>3 this function generates the 8-dimensional point set

  { (i,i^2,i^3,i^4) | 0 <= i < n } x { (j,j^2,j^3,j^4) | 0 <= j < n }

one 8-tuple per line, all preceded by a line containing 8.
This is meant as input to the higher-dimensional convex hull
program under development at MPI.

For input parameter n, there will be n^2 vertices and n(n-3) facets.
However, these facets are highly degenerate, and their triangulation
should require \Omega(n^4) simplices.

*/

#include <stdio.h>

#define error(x) {fprintf(stderr,"%s\n",x); exit(-1);}

main(int argc, char *argv[])
{
int i,j,n;

if (argc!=2) error("incorrect usage");

if (sscanf(argv[1],"%d",&n)!=1 || n<4)
  error("argument must be integer greater than 3");


printf("8\n%d\n",n*n);

for (i=0;i<n;i++)
  for (j=0;j<n;j++)
    printf("%d %d %d %d %d %d %d %d\n",i,i*i,i*i*i,i*i*i*i,j,j*j,j*j*j,
                 j*j*j*j);

}

