#ifndef D_RAY_H
#define D_RAY_H


class d_rat_point;

class d_ray;


#include "hyperplane.h"
#include "numberdef"
#include "d_rat_point.h"
#include <LEDA/integer.h>
#include <LEDA/handle_types.h>


 


//------------------------------------------------------------------------------
// rays in d - space
//------------------------------------------------------------------------------

class d_ray_rep  : public handle_rep {

friend class d_rat_point;
friend class d_ray;
   
d_rat_point source;
d_rat_point target;


/* A ray in $d$-space is defined by two points called its |source| and
|target| target respectively. The ray is oriented from source to target.
The class d_ray is a handle class.  */


public:

d_ray_rep(){}  // a ray in zero-dimensional space
   
d_ray_rep(d_rat_point p,d_rat_point q)
   { if (p.dim() != q.dim() || ( p == q)) error_handler(1,"d_ray constructor::source 
and target must have the same dimension and must be different") ;
   source = p;
   target = q;
   }


 
~d_ray_rep(){}





   
LEDA_MEMORY(d_ray_rep)
};



/*{\Manpage {d_ray} {} {Lines in $d$-dimensional space} }*/

class d_ray  : public handle_base {

/*{\Mdefinition
An instance of the data type $d_ray$ is a ray is $d$-dimensional Euclidian
space. It is defined by two points |source| and |target| and oriented from
source to target. }*/



d_ray_rep* ptr() const { return (d_ray_rep*)PTR; } 

public:



/*{\Mcreation h}*/

d_ray(){PTR = new d_ray_rep();}
/*{/Mcreate introduces a ray in 0-dimensional space}*/

d_ray(d_rat_point p,d_rat_point q) { PTR = new d_ray_rep(p,q); }
/*{\Mcreate introduces a ray through |p| and |q| and oriented
from |p| to |q|.}*/



 d_ray(const d_ray& p) : handle_base(p) {}
~d_ray()            {}  //      { clear(); } relict

 d_ray& operator=(const d_ray& p) 
 { handle_base::operator=(p); return *this; }

/*{\Moperations 2 3.5 }*/



int dim() const {return (ptr()->source).dim();}
/*{\Mop     returns the dimension of the underlying space.}*/

d_rat_point source() const {return ptr()->source;}
/*{\Mop     returns the source point.}*/


d_rat_point target() const {return ptr()->target;}
/*{\Mop     returns the target point.}*/





friend bool intersection(const hyperplane & h, const d_ray & l,d_rat_point& p);
    /*{\Mfuncl returns whether the hyperplane |h|
with the ray |l| intersect. If so, the intersection is returned in |p|.}*/



friend bool identical(const d_ray& l1, const d_ray& l2)
{ return l1.ptr() == l2.ptr(); }
/*{\Mbinopfunc  test for identity.}*/

friend bool operator==(const d_ray& l1, const d_ray& l2);
/*{\Mbinopfunc  test for equality.}*/

friend bool operator!=(const d_ray& l1, const d_ray& l2)
/*{\Mbinopfunc  test for inequality.}*/
{return (!(l1 == l2));}

friend ostream& operator<<(ostream& O, const d_ray& l) 
{error_handler(1,"not implemented yet");}
/*{\Mbinopfunc  writes the coefficients  of \var\ to 
                output stream $O$.}*/

friend istream& operator>>(istream& I, d_ray& l) 
{error_handler(1,"not implemented yet");}

/*{\Mbinopfunc  reads the coefficients of \var\ from 
                input stream $I$. This operator uses the current dimension
                of  \var.}*/






int cmp(const d_ray&, const d_ray&)
{error_handler(1,"not implemented"); return 1;}

};

//LEDA_HANDLE_TYPE(d_ray)

inline void Print(const d_ray& l, ostream& out) { out << l; } 
inline void Read(d_ray& l,  istream& in)        { in >> l; }









#endif





